<?php
namespace VM\FinancialStatementsBundle\Services\Restrictions\Departments\Api;


use VM\AdminBundle\Services\ApiGetter;
use VM\ApiBundle\Entity\Company;
use VM\ApiBundle\Entity\Department;
use VM\ApiBundle\Entity\MarketSegment;
use VM\FinancialStatementsBundle\Services\Restrictions\DepartmentRestrictionsDS;

class BasicDepartmentsRestrictions
{
    /**
     * @var \Symfony\Component\DependencyInjection\Container
     */
    protected $Container;

    /**
     * @var MarketSegment
     */
    public $MarketSegment;

    /**
     * @var Department
     */
    public $Department;

    /**
     * @var Company
     */
    public $Company;

    /**
     * @var DepartmentRestrictionsDS
     */
    public $resultsData;

    public $restrictions = array();

    public $errors = array();

    public $equipment = array();

    public $countPackageEquipment = 1;

    public $valid = true;

    public function __construct(\Symfony\Component\DependencyInjection\Container $Container)
    {
        $this->Container = $Container;
//        $this->resultsData = new DepartmentRestrictionsDS();
    }

    protected function get($service)
    {
        return $this->Container->get($service);
    }

    /**
     * @return \Doctrine\Bundle\DoctrineBundle\Registry
     */
    protected function getDoctrine()
    {
        return $this->Container->get('doctrine');
    }

    public function setData(MarketSegment $MarketSegment, Department $Department, Company $Company,DepartmentRestrictionsDS $DepartmentRestrictionsDS)
    {
        $this->MarketSegment = $MarketSegment;
        $this->Department = $Department;
        $this->Company = $Company;
        $this->resultsData = $DepartmentRestrictionsDS;

        $this->restrictions = json_decode($Department->getRestrictions(),true);
        if(!isset($this->restrictions['surface']))
        {
            $this->restrictions['surface'] = 0;
        }
        if(!isset($this->restrictions['items']))
        {
            $this->restrictions['items'] = null;
        }
        if(!isset($this->restrictions['driver']))
        {
            $this->restrictions['driver'] = null;
        }
        if(!isset($this->restrictions['efficiencyBiR']))
        {
            $this->restrictions['efficiencyBiR'] = null;
        }

        $this->restrictions['personnel'] = (isset($this->restrictions['personnel'])) ? explode('|',$this->restrictions['personnel']) : array();
        $this->restrictions['education'] = (isset($this->restrictions['education'])) ? explode('|',$this->restrictions['education']) : null;
        $this->restrictions['studies'] = (isset($this->restrictions['studies'])) ? explode('|',$this->restrictions['studies']) : null;
        $this->restrictions['efficiency'] = (isset($this->restrictions['efficiency'])) ? explode('|',$this->restrictions['efficiency']) : array();
    }

    public function getErrors()
    {
        return $this->errors;
    }

    public function getResultsData()
    {
        return $this->resultsData;
    }
    /**
     * @return ApiGetter
     */
    protected function getApiGetter()
    {
        return $this->get('vm_admin.api.getter');
    }
}